#include <vcl.h>
#pragma hdrstop

#include "MainU.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TForm1 *Form1;

__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // If there are two params then they are the
  // /p switch followed by the file name.
  if (ParamCount() > 1) {
    // First param is the print command.
    if (ParamStr(1) == "/p") {
      Visible = false;
      // Load the file, print, and exit.
      RichEdit->Lines->LoadFromFile(ParamStr(2));
      Print1Click(0);
      Application->Terminate();
    }
  }
  // Not printing, just load the file.
  else if (ParamCount() == 1)
    RichEdit->Lines->LoadFromFile(ParamStr(1));
}

void __fastcall TForm1::Open1Click(TObject *Sender)
{
  if (OpenDialog->Execute())
    RichEdit->Lines->LoadFromFile(
      OpenDialog->FileName);
}

void __fastcall TForm1::Save1Click(TObject *Sender)
{
  if (SaveDialog->Execute())
    RichEdit->Lines->SaveToFile(
      SaveDialog->FileName);
}

void __fastcall TForm1::Print1Click(TObject *Sender)
{
  RichEdit->Print("Test App Document");
}

void __fastcall TForm1::Exit1Click(TObject *Sender)
{
  Close();
}

void __fastcall
TForm1::CreateFileAssociation1Click(TObject *Sender)
{
  // Create the registry keys.
  TRegistry* reg = new TRegistry;
  try {
    reg->RootKey = HKEY_CLASSES_ROOT;
    // Create the file extension key.
    reg->OpenKey(".zzy", true);
    reg->WriteString("", "Test App File");

    // Create the file association key and
    // its open, print, and DefaultIcon keys.
    reg->OpenKey("\\Test App File\\"
      "shell\\open\\command", true);
    reg->WriteString("", ParamStr(0) + " %1");
    reg->OpenKey("\\Test App File\\"
      "shell\\print\\command", true);
    reg->WriteString("", ParamStr(0) + " /p %1");
    reg->OpenKey(
      "\\Test App File\\DefaultIcon", true);
    reg->WriteString("", ParamStr(0) + ",0");

    MessageDlg("File association created!\r\n"
      "You may have to restart Windows to see "
      "the proper icon for a ZZY file.",
      mtInformation, TMsgDlgButtons() << mbOK, 0);
  }
  catch (...) {
    delete reg;
    return;
  }
  delete reg;
}

void __fastcall
TForm1::RemoveFileAssociation1Click(TObject *Sender)
{
  // Delete the two registry keys.
  TRegistry* reg = new TRegistry;
  try {
    reg->RootKey = HKEY_CLASSES_ROOT;
    reg->DeleteKey(".zzy");
    reg->DeleteKey("Test App File");

    MessageDlg("File association removed!",
      mtInformation, TMsgDlgButtons() << mbOK, 0);
  }
  catch (...) {
    delete reg;
    return;
  }
  delete reg;
}

void __fastcall
TForm1::WmCopyData(TWMCopyData& Message)
{
  String S = (char*)Message.CopyDataStruct->lpData;
  S = S + '\0';
  int pos = S.Pos("/p");
  if (pos) {
    // Printing. Create a temp TRichEdit
    // to do the printing.
    S.Delete(1, pos + 2);
    TRichEdit* re = new TRichEdit(this);
    re->Visible = false;
    re->Parent = this;
    re->Lines->LoadFromFile(S);
    re->Print("Test App Document");
    delete re;
    return;
  } else {
    // Not printing, just load the file.
    RichEdit->Lines->LoadFromFile(S);
    OpenDialog->FileName = S;
    SaveDialog->FileName = S;
  }
}

